package turingmachine;

/**
 * A transition function maps tuples (z, a) to tuples (z', b, d), where
 *     z is a state from Z \ E
 *     z' is a state from Z 
 *     a and b are symbols from Gamma
 *     d is a direction from {L, R, N}
 *
 * The class TransitionEffect represents the effect (z', b, d) that a transition
 * has, i.e., the next state z', the symbol b to write, and the direction d in which
 * to move the head.
 * We never compare or hash TransitionEffect objects, so we do not need to override
 * equals() or hashCode().
 */
public class TransitionEffect {
    private final State state;
    private final Symbol symbol;
    private final Direction direction;
    
    public TransitionEffect(State state, Symbol symbol, Direction direction) {
        this.state = state;
        this.symbol = symbol;
        this.direction = direction;
    }

    public State getState() {
        return state;
    }

    public Symbol getSymbol() {
        return symbol;
    }
    
    public Direction getDirection() {
        return direction;
    }
}