package turingmachine;

import java.util.List;
import java.util.Set;
// TODO: add necessary imports

/**
 * A deterministic Turing machine that can be simulated for a finite number of
 * steps or until resources run out.
 */
public class TuringMachine {
    // TODO: Define necessary private fields.

    /**
     * Construct a Turing machine and check input for validity.
     * @param Z a set of states
     * @param Sigma input alphabet
     * @param Gamma tape alphabet
     * @param delta transition function
     * @param z0 initial state
     * @param blank blank symbol
     * @param E set of final states
     * @throws InvalidSpecificationException if the input does not describe a
     *         Turing machine (see exercise sheet).
     */
    public TuringMachine(Set<State> Z,
                         Set<Symbol> Sigma,
                         Set<Symbol> Gamma,
                         TransitionFunction delta,
                         State z0,
                         Symbol blank,
                         Set<State> E) throws InvalidSpecificationException {
        // Construct Turing Machine.
        // TODO

        // Check that delta is a total function from (Z \E) x Gamma to Z x Gamma x {L, R, N}.
        // TODO

        // Check that Sigma is a subset of Gamma.
        // TODO

        // Check that blank is in Gamma but not in Sigma.
        // TODO

        // Check that E is a subset of Z.
        // TODO
    }

    /**
     * Reset the Turing machine to the initial configuration for the given word.
     * @param word the input of the Turing machine simulation.
     * @throws InvalidSpecificationException if the given word contains symbols not in Sigma.
     */
    public void initialize(List<Symbol> word) throws InvalidSpecificationException {
        // Check that all symbols of word are from the input alphabet.
        // TODO

        // Reset to initial configuration for the input word.
        // TODO
    }

    /**
     * Simulate one step of the Turing machine. The machine must have been initialized and before
     * calling this function. Once the simulation is over, i.e., the Turing machine stops, the
     * machine must be re-initialized before calling step() again.
     * @throws RuntimeException if the Turing machine is not initialized or is in a final state.
     */
    private void step() {
        // Check if the machine is not initialized.
        // TODO

        // Check if the machine is in a final state.
        // TODO

        // Simulate one step
        // TODO
    }

    /**
     * Simulate the Turing machine until it stops, or resources run out.
     * The Turing machine must be initialized before calling this function.
     */
    public void run() {
        // We simulate up to Long.MAX_VALUE steps. Resources will run out
        // before we will reach this number of simulated steps.
        run(Integer.MAX_VALUE);
    }

    /**
     * Simulate the Turing machine for up to maxSteps steps, or until it stops,
     * or resources run out.
     * The Turing machine must be initialized before calling this function.
     * @param maxSteps maximal number of steps to simulate or null if no limit should be used.
     */
    public void run(Integer maxSteps) {
        // TODO
    }

    /**
     * Print the current configuration of the Turing machine.
     */
    public void dumpConfiguration() {
        // TODO
    }

    /**
     * Print the number of steps simulated so far and the current size of the used tape.
     */
    public void dumpStatistics() {
        // TODO
    }
}
