package turingmachine;

/**
 * This class is a basic wrapper around String with the interface restricted
 * to what we need for symbols. A symbol can be any string but typically, we use
 * single lower-case characters (a,b,c, ...). As blank symbol, you can for example
 * use the character '.'
 * Two symbols are equal iff they have the same name.
 */
public class Symbol {
    private final String name;

    public Symbol(String name) {
        this.name = name;
    }

    public String toString() {
        return name;
    }

    /**
     * We have to override hashCode() since we override equals().
     */
    @Override
    public int hashCode() {
        return (name == null) ? 0 : name.hashCode();
    }

    /**
     * Two symbols are equal iff they have the same name.
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Symbol))
            return false;
        Symbol other = (Symbol) obj;
        if (name == null) {
            if (other.name != null)
                return false;
        } else if (!name.equals(other.name))
            return false;
        return true;
    }
}
