package turingmachine;

/**
 * A transition function maps tuples (z, a) to tuples (z', b, d), where
 *     z is a state from Z \ E
 *     z' is a state from Z 
 *     a and b are symbols from Gamma
 *     d is a direction from {L, R, N}
 *
 * The class TransitionCondition represents the condition (z, a) under which a
 * transition can be used, i.e., the current state z and the symbol a under the head.
 */
public class TransitionCondition {
    private final State state;
    private final Symbol symbol;
    
    public TransitionCondition(State state, Symbol symbol) {
        this.state = state;
        this.symbol = symbol;
    }

    public State getState() {
        return state;
    }

    public Symbol getSymbol() {
        return symbol;
    }

    /**
     * We have to override hashCode() since we override equals().
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((state == null) ? 0 : state.hashCode());
        result = prime * result + ((symbol == null) ? 0 : symbol.hashCode());
        return result;
    }

    /**
     * Two TransitionCondition objects are equal iff their components are equal.
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (!(obj instanceof TransitionCondition))
            return false;
        TransitionCondition other = (TransitionCondition) obj;
        if (state == null) {
            if (other.state != null)
                return false;
        } else if (!state.equals(other.state))
            return false;
        if (symbol == null) {
            if (other.symbol != null)
                return false;
        } else if (!symbol.equals(other.symbol))
            return false;
        return true;
    }
}
