package recursion.schema;

import recursion.Function;

public class MuRecursion extends Function {
    private static final int LIMIT_MU_TEST = 100;
    private final Function f;

    public MuRecursion(Function f) {
        super(f.getArity() - 1);
        if (f.getArity() < 2) {
            throw new RuntimeException("Tried to apply the mu operator to a function with arity " + f.getArity());
        }
        this.f = f;
    }

    @Override
    protected int computeValue(int[] args) {
        for (int n = 0; n < LIMIT_MU_TEST; ++n) {
            int[] fArgs = new int[args.length + 1];
            fArgs[0] = n;
            for (int i = 0; i < args.length; ++i) {
                fArgs[i + 1] = args[i];
            }
            int fRes = f.compute(fArgs);
            if (fRes == 0)
                return n;
        }
        throw new RuntimeException("We simulated f for " + LIMIT_MU_TEST
                           + " steps without finding a parameter where f is zero."
                           + " This could mean that mu(f) is not defined for the given parameters,"
                           + " but it is no guarantee. To show that mu(f) is undefined for some"
                           + " parameters by simulation, we would have to simulate an infinite amount of steps.");
    }

}
