package recursion.basefunctions;

import recursion.Function;

public class Projection extends Function {
    private final int projectTo;

    public Projection(int arity, int projectTo) {
        super(arity);
        if (arity < 1) {
            throw new RuntimeException("Trying to create a projection for a "
                + arity + "-tuple");
        }
        if (projectTo < 1 || projectTo > arity) {
            throw new RuntimeException("Trying to create a projection that projects a "
                + arity + "-tuple to its " + projectTo + "th component.");
        }
        this.projectTo = projectTo;
    }

    @Override
    protected int computeValue(int[] args) {
        // Index in args starts at 0, but definition of projection starts at 1.
        return args[projectTo - 1];
    }

}
