package logic.formulas;

/** 
 * A negation is a formula expressing that something is not the case.
 * It is written without parentheses and a "~" in front, e.g., "~phi".
 */
public class Negation extends Formula {
    // The subformula that is negated by this formula (phi in the example above)
    private Formula negatedFormula;

    public Negation(Formula negatedFormula) {
        this.negatedFormula = negatedFormula;
    }

    public Formula getNegatedFormula() {
        return negatedFormula;
    }

    @Override
    public String toString() {
        return "~" + negatedFormula;
    }
}
