package logic.formulas;

public abstract class Formula {

    /*
     * NOTE:
     * Equality on formulas is equality on the syntactic level.
     * To emphasize this, we implement hashing and equality as
     * functions of the string representation. In general this
     * is not good practice because the string concatenation used
     * in toString() makes the code unnecessarily slow.
     */

    /**
     * hashCode() must be implemented if equals() has a custom implementation.
     * Here we just delegate the calculation of the hash code to the String
     * class and return the string representation's hash code.
     */
    @Override
    public int hashCode() {
        String s = this.toString();
        return s == null ? 0 : s.hashCode();
    }

    /**
     * Two formulas are equal iff their string representation is the same.
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (!(obj instanceof Formula))
            return false;
        String s1 = this.toString();
        String s2 = obj.toString();
        if (s1 == null || s2 == null)
            return false;
        return s1.equals(s2);
    }
}
