package logic.formulas;

/*
 * NOTE:
 * We could have implemented all (binary) formulas with inheritance
 * without so much duplicated code. While this would be a better design,
 * we hope that this more specific approach is easier to understand.
 */

/** 
 * A conjunction is a formula expressing that both of two subformulas are true.
 * It is written with parentheses and a "/\" between the subformulas,
 * e.g., "(phi /\ psi)".
 */
public class Conjunction extends Formula {
    // Left-hand side (phi in the example above)
    private Formula lhs;
    // Right-hand side (psi in the example above)
    private Formula rhs;

    public Conjunction(Formula lhs, Formula rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public Formula getLhs() {
        return lhs;
    }

    public Formula getRhs() {
        return rhs;
    }

    @Override
    public String toString() {
        return "(" + lhs + " /\\ " + rhs + ")";
    }
}
