#! /usr/bin/env python
# -*- coding: utf-8 -*-

import random

blocks = list("abcdefghijklmnopqrstuvwxyz")
random.shuffle(blocks)

towers = []
curr_tower = []
for block in blocks:
    if curr_tower and random.choice([False, True]):
        towers.append(curr_tower)
        curr_tower = []
    curr_tower.append(block)
towers.append(curr_tower)

for tower in towers:
    print "   (clear %s)" % tower[0]
    for above, below in zip(tower, tower[1:]):
        print "   (on %s %s)" % (above, below)
    print "   (on-table %s)" % tower[-1]
