(define (domain sliding-tile-puzzle)

  (:requirements :typing :action-costs)

  (:types tile row column - object)

  (:predicates (ROW-ABOVE ?row1 - row ?row2 - row)
               (COLUMN-LEFT ?col1 - column ?col2 - column)
	       (tile-at ?t - tile ?r - row ?c - column)
	       (is-blank ?r - row ?c - column))

  (:functions (total-cost) - number)

  ;; As is conventional for the sliding-tile puzzle, action names are
  ;; from the perspective of the blank tile, so e.g. "right" means
  ;; moving the blank to the right.

  (:action left
   :parameters (?t - tile
                ?old-column - column
                ?new-column - column
                ?row - row)
   :precondition (and (COLUMN-LEFT ?new-column ?old-column)
                      (is-blank ?row ?old-column)
                      (tile-at ?t ?row ?new-column))
   :effect       (and (not (is-blank ?row ?old-column))
                      (is-blank ?row ?new-column)
                      (not (tile-at ?t ?row ?new-column))
                      (tile-at ?t ?row ?old-column)
                      (increase (total-cost) 1)))

  (:action right
   :parameters (?t - tile
                ?old-column - column
                ?new-column - column
                ?row - row)
   :precondition (and (COLUMN-LEFT ?old-column ?new-column)
                      (is-blank ?row ?old-column)
                      (tile-at ?t ?row ?new-column))
   :effect       (and (not (is-blank ?row ?old-column))
                      (is-blank ?row ?new-column)
                      (not (tile-at ?t ?row ?new-column))
                      (tile-at ?t ?row ?old-column)
                      (increase (total-cost) 1)))

  (:action up
   :parameters (?t - tile
                ?old-row - row
                ?new-row - row
                ?column - column)
   :precondition (and (ROW-ABOVE ?new-row ?old-row)
                      (is-blank ?old-row ?column)
                      (tile-at ?t ?new-row ?column))
   :effect       (and (not (is-blank ?old-row ?column))
                      (is-blank ?new-row ?column)
                      (not (tile-at ?t ?new-row ?column))
                      (tile-at ?t ?old-row ?column)
                      (increase (total-cost) 1)))

  (:action down
   :parameters (?t - tile
                ?old-row - row
                ?new-row - row
                ?column - column)
   :precondition (and (ROW-ABOVE ?old-row ?new-row)
                      (is-blank ?old-row ?column)
                      (tile-at ?t ?new-row ?column))
   :effect       (and (not (is-blank ?old-row ?column))
                      (is-blank ?new-row ?column)
                      (not (tile-at ?t ?new-row ?column))
                      (tile-at ?t ?old-row ?column)
                      (increase (total-cost) 1)))

)
