import java.util.ArrayList;


public class TrivialStateSpace implements StateSpace {
    private static class TrivialState implements State {
        int value;

        public TrivialState(int value) {
            this.value = value;
        }

        public String toString() {
            return "TrivialState(" + value + ")";
        }
    }

    private static class TrivialAction implements Action {
        int parameter;

        public TrivialAction(int parameter) {
            this.parameter = parameter;
        }

        public String toString() {
            return "TrivialAction(" + parameter + ")";
        }
    }

    private TrivialStateSpace() {
    }

    public State init() {
        return new TrivialState(0);
    }

    public boolean isGoal(State s_) {
        TrivialState s = (TrivialState) s_;

        return s.value == 2;
    }

    public ArrayList<ActionStatePair> succ(State s_) {
        TrivialState s = (TrivialState) s_;

        ArrayList<ActionStatePair> result = new ArrayList<ActionStatePair>();

        TrivialAction action;
        TrivialState succState;

        if (s.value > 0) {
            action = new TrivialAction(-1);
            succState = new TrivialState(s.value - 1);
            result.add(new ActionStatePair(action, succState));
        }

        if (s.value < 2) {
            action = new TrivialAction(+1);
            succState = new TrivialState(s.value + 1);
            result.add(new ActionStatePair(action, succState));
        }

        return result;
    }

    public int cost(Action a) {
        return 1;
    }

    public static StateSpace buildFromCmdline(ArrayList<String> args) {
        if (args.isEmpty()) {
            return new TrivialStateSpace();
        } else {
            Errors.usageError("trivial state space doesn't take arguments");
            return null;
        }
    }
}
