#include "minefield.h"
#include "gnomineSolver.h"
#include <gtk/gtk.h>
#include <iostream>

/*
 * Encodes the 8 Neighbours. Offset is the following:
 * 012
 * 3-4
 * 567
 * returns -1 if c is not a valid number
 */
int GnomineSolver::getNeighbour(int c, int offset) {
  int x = c % ((int)mfield->xsize);
  int y = c / ((int)mfield->xsize);
  switch(offset) {
  case 0:
    x = x-1;
    y = y-1;
    break;
  case 1:
    y = y-1;
    break;
  case 2:
    x = x+1;
    y = y-1;
    break;
  case 3:
    x = x-1;
    break;
  case 4:
    x = x+1;
    break;
  case 5:
    x = x-1;
    y = y+1;
    break;
  case 6:
    y = y+1;
    break;
  case 7:
    x = x+1;
    y = y+1;
    break;
  }
  if(x < 0 || x >= (int)mfield->xsize || y < 0 || y >= (int)mfield->ysize) {
    return -1;
  }
  return y*(int)mfield->xsize + x;
};

