#include "minefield.h"
#include "gnomineSolver.h"
#include <stdlib.h>
#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <vector>

#ifndef GNOMINESOLVER_CSP_H
#define GNOMINESOLVER_CSP_H

struct csp_gui {
  GtkWidget *window;
  GtkWidget *fieldarea;
  GtkWidget *textarea;
  GtkWidget *buttonarea;
  GtkWidget *playRB;
  GtkWidget *analyzeRB;
};

//info for the gui
struct csp_info {
  int numbers[8];
  int states[8];
  int sum;
  int field;
  int possible_combinations;
  int tested_combinations;
  int active_constraint_state;
};

//info for the global State (for buttons)
struct csp_currentState {
  std::vector<int> activeConstraints;
  std::vector<int> uncertainValues;
  int activeConstraintsPos;
  int valuePossible[2];
};

class GnomineSolver_CSP : public GnomineSolver {
 private:
  struct csp_gui gui;
  struct csp_info info;
  struct csp_currentState currentState;

  //functions for checking/preparing a certain aspect of CSP
  std::vector<int> prepareConstraint(int c);
  void prepareVariable(int var);
  bool checkVariable(int var, std::vector<int> uncertainConstraints);
  bool validCombinationExists(int numbers[8], int correct_sum, std::vector<int> uncertainConstraints);
  bool combinationIsValid(int numbers[8], int correct_sum);
  void resetInfo();
  void createCurrentState();
  void buildExtraGUI();
  void updateInConsole(const int x[8], bool valid);
  void setBackgroundMinefield(int c, int state);

  //help functions
  std::vector<int> getActiveConstraints();
  bool hasUncertainNeighbours(int c);
  void fillNumberArray(int numbers[8], int n, std::vector<int> uncertainConstraints);

 public:
  GnomineSolver_CSP(GtkMineField *mfield);
  ~GnomineSolver_CSP();
  virtual void checkMField();
  virtual void analyzeField(int field);
  virtual gboolean gtk_extra_gui_update();
  virtual void updateMfieldValues();
  static gboolean gtk_extra_gui_expose_proxy(GtkWidget * widget, GdkEventExpose * event, gpointer data);
  static void checkField_proxy(void *args);

  static void applyChangesCallback(GtkWidget * widget, gpointer data);
  static void nextConstraintCallback(GtkWidget * widget, gpointer data);
  static void nextVariableCallback(GtkWidget * widget, gpointer data);
  static void checkFieldCallback(GtkWidget * widget, gpointer data);
  static void nextStepCallback(GtkWidget * widget, gpointer data);
  static void toggleAnalyzeModeCallback(GtkWidget * widget, gpointer data);
  virtual void applyChanges();
  void nextConstraint(bool refreshActiveConstraints = false, int jumpToConstraint = -1);
  void nextVariable();
  void nextStep();

};

#endif /*GNOMINESOLVER_CSP_H*/
