#include "minisat/core/Solver.h"
#include "minisat/core/SolverTypes.h"
#include "minisat/mtl/Vec.h"
#include "minefield.h"
#include "gnomineSolver.h"
#include <unordered_map>
#include <vector>

#ifndef GNOMINESOLVER_BACKBONE_H
#define GNOMINESOLVER_BACKBONE_H

struct backbone_state {
  std::unordered_map<int, bool> lambda;
  std::unordered_map<int, bool> backbone;
  Minisat::Solver * satSolver;
  int currentField;
  Minisat::vec<Minisat::lbool> oldModel;
  Minisat::vec<Minisat::lbool> newModel;
  bool started;
  bool finished;
};

struct backbone_gui {
  GtkWidget *window;
  GtkWidget *fieldarea;
  GtkWidget *buttonarea;
  GtkWidget *analyzeRB;
  GtkWidget *playRB;
};

class GnomineSolver_Backbone : public GnomineSolver {
 private:
  backbone_state state;
  bool withGlobalConstraint;
  backbone_gui gui;

  std::unordered_map<int,bool> calculateBackbone();
  Minisat::lbool checkFieldForBackbonePrimitive(int var);
  Minisat::lbool checkFieldForBackboneWithMemory(int var);

  void addClausesFromConstraint(int c, Minisat::Solver * s, bool neighbours[8], int neighbourCount, int sum);
  void addGlobalFlagConstraint(Minisat::Solver *s);
  int atMostKConstraint(Minisat::Solver *s, int n, int k, int log2_n, bool inverted, int startingPoint, std::vector<int> &fieldmap);
  void insertModelIntoLambda(Minisat::Solver *s, std::unordered_map<int,bool> * lambda);

  int getUncertainNeighbours(int c, bool neighbours[8]);
  void resetState();
;

 public:
  GnomineSolver_Backbone(GtkMineField *mfield);
  ~GnomineSolver_Backbone();
  void setupSolver();
  virtual void checkMField();
  virtual void applyChanges();
  virtual void analyzeField(int field);
  virtual void buildExtraGUI();
  virtual gboolean gtk_extra_gui_update();
  virtual void updateMfieldValues();

  static gboolean gtk_extra_gui_expose_proxy(GtkWidget * widget, GdkEventExpose * event, gpointer data);
  static void checkNextField(GtkWidget * widget, gpointer data);
  static void checkFieldCallback(GtkWidget * widget, gpointer data);
  static void applyChangesCallback(GtkWidget *widget, gpointer data);
  static void toggleAnalyzeModeCallback(GtkWidget *widget, gpointer data);
  static void toggleGlobalConstraintCallback(GtkWidget *widget, gpointer data);
};


#endif /* GNOMINESOLVER_BACKBONE_H */
