(define (domain gripper)
   (:requirements :strips)

   (:predicates (ROOM ?r)
                (BALL ?b)
                (GRIPPER ?g)
                (at-robby ?r)
                (at-ball ?b ?r)
                (free ?g)
                (carry ?g ?b))

   (:action move
       :parameters (?from ?to)
       :precondition (and (ROOM ?from)
                          (ROOM ?to)
                          (at-robby ?from)
                     )
       :effect (and (at-robby ?to)
                    (not (at-robby ?from))
               )
   )

   (:action pick-up
       :parameters (?ball ?room ?gripper)
       :precondition (and (BALL ?ball)
                          (ROOM ?room)
                          (GRIPPER ?gripper)
                          (at-ball ?ball ?room)
                          (at-robby ?room)
                          (free ?gripper)
                     )
       :effect (and (carry ?gripper ?ball)
                    (not (at-ball ?ball ?room)) 
                    (not (free ?gripper))
               )
   )


   (:action drop
       :parameters (?ball ?room ?gripper)
       :precondition (and (BALL ?ball)
                          (ROOM ?room)
                          (GRIPPER ?gripper)
                          (carry ?gripper ?ball)
                          (at-robby ?room)
                     )
       :effect (and (at-ball ?ball ?room)
                    (free ?gripper)
                    (not (carry ?gripper ?ball))
               )
   )
)
