;; TSP problem instance with 4 cities

(define (problem tsp-4)
    (:domain tsp)
    (:objects
     city0 - city
     city1 - city
     city2 - city
     city3 - city
    )
    (:init
        (= (total-cost) 0)
        (current-city city0)
        (must-still-visit city0)
        (must-still-visit city1)
        (must-still-visit city2)
        (must-still-visit city3)
        (= (DISTANCE city0 city0) 0)
        (= (DISTANCE city0 city1) 472)
        (= (DISTANCE city0 city2) 396)
        (= (DISTANCE city0 city3) 796)
        (= (DISTANCE city1 city0) 472)
        (= (DISTANCE city1 city1) 0)
        (= (DISTANCE city1 city2) 148)
        (= (DISTANCE city1 city3) 517)
        (= (DISTANCE city2 city0) 396)
        (= (DISTANCE city2 city1) 148)
        (= (DISTANCE city2 city2) 0)
        (= (DISTANCE city2 city3) 656)
        (= (DISTANCE city3 city0) 796)
        (= (DISTANCE city3 city1) 517)
        (= (DISTANCE city3 city2) 656)
        (= (DISTANCE city3 city3) 0)
    )
    (:goal (and
            (have-visited city0)
            (have-visited city1)
            (have-visited city2)
            (have-visited city3)
            (current-city city0)
           ))
    (:metric minimize (total-cost))
)
