;; TSP domain

;; Notes:
;;
;; 1. Unlike the formulation we used in our problem-specific code,
;;    here we don't count the initial city as "visited" at the start,
;;    but only when we *revisit* it at the end. This helps express the
;;    preconditions of operators and the goal in a simpler way.
;;
;; 2. We also drop the rule that says it is forbidden to move back to
;;    the initial city before everything else has been visited. This
;;    allows us to do some moves that are not actually legal, but this
;;    doesn't affect correctness since after moving back to the
;;    initial city "too early", we can never reach a goal state. (Once
;;    we leave the initial city again, the goal of being there at the
;;    end becomes impossible.) Dropping the rule again helps us write
;;    up the problem in a simpler way.

(define (domain tsp)
    (:requirements :typing :action-costs)
    (:types city)
    (:predicates
     (must-still-visit ?c - city)
     (have-visited ?c - city)
     (current-city ?c - city)
     )
    (:functions
     (DISTANCE ?c1 ?c2 - city) - number
     (total-cost) - number
     )

    (:action travel
     :parameters (?from-city ?to-city - city)
     :precondition (and (current-city ?from-city)
                        (must-still-visit ?to-city))
     :effect (and (not (current-city ?from-city))
                  (current-city ?to-city)
                  (not (must-still-visit ?to-city))
                  (have-visited ?to-city)
                  (increase (total-cost) (DISTANCE ?from-city ?to-city))))
)