(define (domain NxM-PUZZLE)
  (:requirements :strips)
  (:predicates 
           (right-of ?pos1 ?pos2)  ;; pos1 is right of pos2
           (below-of ?pos1 ?pos2)  ;; pos1 is below of pos2
	       (blank ?pos)
           (at ?tile ?pos) 
  )

  ;; move blank upwards 
  (:action up
	     :parameters (?from ?to ?tile)
	     :precondition (and (blank ?from) (below-of ?from ?to) (at ?tile ?to))
	     :effect
	     (and (not (at ?tile ?to))
		      (not (blank ?from))
              (at ?tile ?from)
              (blank ?to)))

  ;; move blank downwards 
  (:action down
	     :parameters (?from ?to ?tile)
	     :precondition (and (blank ?from) (below-of ?to ?from) (at ?tile ?to))
	     :effect
	     (and (not (at ?tile ?to))
		      (not (blank ?from))
              (at ?tile ?from)
              (blank ?to)))

  ;; move blank to the left 
  (:action left
	     :parameters (?from ?to ?tile)
	     :precondition (and (blank ?from) (right-of ?from ?to) (at ?tile ?to))
	     :effect
	     (and (not (at ?tile ?to))
		      (not (blank ?from))
              (at ?tile ?from)
              (blank ?to)))

  ;; move blank to the right 
  (:action right
	     :parameters (?from ?to ?tile)
	     :precondition (and (blank ?from) (right-of ?to ?from) (at ?tile ?to))
	     :effect
	     (and (not (at ?tile ?to))
		      (not (blank ?from))
              (at ?tile ?from)
              (blank ?to)))
)
