package search;

import java.util.LinkedList;
import java.util.List;

public class Node {
	private final Node parent;
	private final Action action;
	private final State state;
    private final int g;
    
    public Node(Node parent, Action action, State state, int g) {
    	if (state == null) {
    		throw new IllegalArgumentException("State cannot be null");
    	}    	
    	if (g < 0) {
    		throw new IllegalArgumentException("g-value must be non-negative");
    	}
    	
    	this.parent = parent;
    	this.action = action;
    	this.state = state;
    	this.g = g;
    }
    
	public State getState() {
		return state;
	}
	
	public Node getParent() {
		return parent;
	}
	
	public Action getAction() {
		return action;
	}
	
	public int getGValue() {
		return g;
	}

	public List<Action> extractSolution() {
		LinkedList<Action> list = new LinkedList<Action>();
		
		Node n = this;
		while (n.getAction() != null) {
			list.addFirst(n.getAction());
			n = n.getParent();
		}
		
		return list;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((state == null) ? 0 : state.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Node other = (Node) obj;
		if (state == null) {
			if (other.state != null)
				return false;
		} else if (!state.equals(other.state))
			return false;
		return true;
	}
}
