package eightpuzzle;

import java.util.Collection;
import java.util.LinkedList;

import search.Action;
import search.State;
import search.StateSpace;
import search.SuccessorPair;
public class EightPuzzleStateSpace implements StateSpace {
	EightPuzzleState initialState;
	Action up;
	Action down;
	Action left;
	Action right;

	public EightPuzzleStateSpace(int[] initpos, int blank) {
		initialState = new EightPuzzleState(initpos, blank);
		up = new EightPuzzleAction("up");
		down = new EightPuzzleAction("down");
		left = new EightPuzzleAction("left");
		right = new EightPuzzleAction("right");
	}

	@Override
	public State init() {
		return initialState;
	}

	@Override
	public boolean isGoal(State s) {
		int[] positions = ((EightPuzzleState) s).getPositions();
		for (int i = 0; i < positions.length - 1; ++i)
			if (positions[i] != i+1) 
				return false;
		return true;
	}

	@Override
	public Collection<SuccessorPair> successors(State s) {
		Collection<SuccessorPair> succs = new LinkedList<SuccessorPair>();

		EightPuzzleState state = (EightPuzzleState) s;
		int[] positions = state.getPositions();
		int blankPos = state.getBlankPos();
		if (blankPos > 2) {
			// generate up successor
			addSuccessor(positions, blankPos, blankPos-3, up, succs);
		}
		if (blankPos < 6) {
			// generate down successor
			addSuccessor(positions, blankPos, blankPos+3, down, succs);
		}
		if (blankPos % 3 != 0) {
			// generate left successor
			addSuccessor(positions, blankPos, blankPos-1, left, succs);
		}
		if (blankPos % 3 != 2) {
			// generate right successor
			addSuccessor(positions, blankPos, blankPos+1, right, succs);
		}
		return succs;
	}
	
	private void addSuccessor(int[] positions, int blank, int nextBlank, Action action,
			Collection<SuccessorPair> successors) {
		int[] successor = (int[]) positions.clone();
		successor[blank] = successor[nextBlank];
		successor[nextBlank] = 0;
		EightPuzzleState succState = new EightPuzzleState(successor, nextBlank);
		successors.add(new SuccessorPair(action, succState));
	}

	@Override
	public int cost(Action a) {
		return 1;
	}
}