package eightpuzzle;

import java.util.Arrays;

import search.State;

public class EightPuzzleState extends State {
	
	private int[] positions; // i-th entry specifies tile at position i (0 for blank)
	int blankPos;
	
	EightPuzzleState(int[] pos, int blank) {
		positions = pos;
		blankPos = blank;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + Arrays.hashCode(positions);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		EightPuzzleState other = (EightPuzzleState) obj;
		if (!Arrays.equals(positions, other.positions))
			return false;
		return true;
	}

	public int[] getPositions() {
		return positions;
	}
	
	public int getBlankPos() {
		return blankPos;
	}
	
	public String toString() {
		String s = "";
		for (int i = 0; i < positions.length; i++) {
			if (positions[i] == 0)
				s += " ";
			else
				s += positions[i];
			if ((i % 3) == 2)
				s += "\n";
			else
				s += " ";
		}
		return s;
	}
}
