package eightpuzzle;

import java.util.List;

import search.Action;

import algorithm.UniformCostSearch;

public class EightPuzzleSolver {

	public static void main(String[] args) {
		int[] initpos = new int[9];
		int blankPos = 36; // = sum 0-8
		assert (args.length == 8);
		for (int i = 0; i < args.length; ++i) {
			initpos[Integer.parseInt(args[i])] = i+1;
			blankPos -= Integer.parseInt(args[i]);
		}
		initpos[blankPos] = 0;
		
		EightPuzzleStateSpace space = new EightPuzzleStateSpace(initpos, blankPos);
		// TODO replace UniformCostSearch with AStarSearch using ManhattanDistanceHeuristic
		UniformCostSearch search = new UniformCostSearch();
		try {
			List<Action> solution = search.search(space);
			System.out.println("Length of solution: " + solution.size());

			for (Action a : solution) {
				System.out.println(((EightPuzzleAction) a).name);
			}

		} catch (Exception e) {
			System.err.println(e.getMessage());
		}
	}

}
