package algorithm;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;

import search.Action;
import search.Node;
import search.SearchAlgorithm;
import search.State;
import search.StateSpace;
import search.SuccessorPair;

public class UniformCostSearch implements SearchAlgorithm {
	class NodeGComparator implements Comparator<Node> {
		@Override
		public int compare(Node n1, Node n2) {
			return n1.getGValue() > n2.getGValue() ? 1 : n1.getGValue() < n2.getGValue() ? -1 : 0;
			// if you use Java 7 or higher, you can alternatively write 
			// return Integer.compare(n1.getGValue(), n2.getGValue());
		}
	}	
	
	@Override
	public List<Action> search(StateSpace space) throws Exception {
		PriorityQueue<Node> open = new PriorityQueue<Node>(100, new NodeGComparator());		
		HashSet<State> closed = new HashSet<State>();
		
		State initState = space.init();
		if (space.isGoal(initState)) {
			// initial state is goal, return empty list
			return new LinkedList<Action>();
		}
		
		Node initNode = new Node(null, null, initState, 0);
		open.add(initNode);
		
		while (!open.isEmpty()) {
		    Node node = open.poll();
		    
		    if (closed.contains(node.getState())) {
		    	// We already found a better node, so ignore this one
		    	continue;
		    }
		    
		    closed.add(node.getState());
			if (space.isGoal(node.getState())) {
			    return node.extractSolution();
			}
			
			Collection<SuccessorPair> successors = space.successors(node.getState());
			for (SuccessorPair pair : successors) {
				Action action = pair.getAction();
				State childState = pair.getState();
				int childGValue = node.getGValue() + space.cost(action);
			    Node childNode = new Node(node, action, childState, childGValue); 
			    open.add(childNode);
			}
		}
		
		throw new Exception("Instance is not solvable");
	}
}
