package algorithm;

import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import search.Action;
import search.Node;
import search.SearchAlgorithm;
import search.State;
import search.StateSpace;
import search.SuccessorPair;

public class BreadthFirstSearch implements SearchAlgorithm {

	@Override
	public List<Action> search(StateSpace stateSpace) throws Exception {
		Deque<Node> open = new LinkedList<Node>();		
		HashSet<State> seen = new HashSet<State>();
		
		State init = stateSpace.init();
		if (stateSpace.isGoal(init)) {
			// initial state is goal, return empty list
			return new LinkedList<Action>();
		}
		
		Node initNode = new Node(null, null, init, 0);
		open.add(initNode);
		seen.add(initNode.getState());
		
		while (!open.isEmpty()) {
			Node node = open.poll();
			
			Collection<SuccessorPair> successors = stateSpace.successors(node.getState());
			for (SuccessorPair pair : successors) {
				Action action = pair.getAction();
				State childState = pair.getState();				
				if (seen.contains(childState)) {
					continue;
				}
				
				int childGValue = node.getGValue() + stateSpace.cost(action);
				Node succNode = new Node(node, action, childState, childGValue);
				if (stateSpace.isGoal(succNode.getState())) {
					return succNode.extractSolution();
				}
				
				open.add(succNode);
				seen.add(succNode.getState());
			}
		}
		
		throw new Exception("Instance is not solvable");
	}

	 //Zwischenversion mit Nodes in seen (oben dann States)
	public List<Action> intermediateSearch(StateSpace stateSpace) throws Exception {
		Deque<Node> open = new LinkedList<Node>();		
		HashSet<Node> seen = new HashSet<Node>();
		
		State init = stateSpace.init();
		if (stateSpace.isGoal(init)) {
			// initial state is goal, return empty list
			return new LinkedList<Action>();
		}
		
		Node initNode = new Node(null, null, init, 0);
		open.add(initNode);
		seen.add(initNode);
		
		while (!open.isEmpty()) {
			Node node = open.poll();
			
			Collection<SuccessorPair> successors = stateSpace.successors(node.getState());
			for (SuccessorPair pair : successors) {
				Action action = pair.getAction();
				State childState = pair.getState();				
				if (seen.contains(childState)) {
					continue;
				}
				
				int childGValue = node.getGValue() + stateSpace.cost(action);
				Node succNode = new Node(node, action, childState, childGValue);
				if (stateSpace.isGoal(succNode.getState())) {
					return succNode.extractSolution();
				}
				
				open.add(succNode);
				seen.add(succNode);
			}
		}
		
		throw new Exception("Instance is not solvable");
	}	
	
}
